package neserializovatelná;

import java.io.*;
import java.util.ArrayList;

public class Nová implements Serializable
{
    private Neserializovatelná potvora = null;
    private int x;
    private ArrayList<Integer> čísla = new ArrayList<>();
    public Nová(int _n)
    {
        x = _n;
        potvora = new Neserializovatelná(_n);
        čísla.add(x*x);
        čísla.add(x*x*x);
    }
    
    @Override
    public String toString()
    {
        StringBuilder výsledek = new StringBuilder("" + x);
        výsledek.append("( " + potvora.getN() + " ) ");
        for(var i : čísla)
        {
            výsledek.append(i.toString() + " ");
        }
        return výsledek.toString();
    }
    
    private void writeObject(ObjectOutputStream výstup) throws IOException
    {
        výstup.writeInt(potvora.getN());
        výstup.writeInt(x);
        výstup.writeObject(čísla);
    }
    
    private void readObject(ObjectInputStream vstup) throws IOException, ClassNotFoundException
    {
        potvora = new Neserializovatelná(vstup.readInt());
        x = vstup.readInt();
        čísla = (ArrayList<Integer>)vstup.readObject();
    }
    
    public void ulož(String jméno) throws IOException
    {
        try(var výstup = new ObjectOutputStream(new FileOutputStream(jméno)))
        {
            výstup.writeObject(this);
        }
    }
    
    public static Nová načti(String jméno) throws IOException, ClassNotFoundException, FileNotFoundException
    {
        try(var vstup = new ObjectInputStream(new FileInputStream(jméno)))
        {
            return (Nová)vstup.readObject();
        }
    }
}
